#include <iostream>
#include <unordered_set>
#include <vector>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    vector<int> ulazi(T);
    int maxN = 0;

    for (int i = 0; i < T; i++) {
        cin >> ulazi[i];
        maxN = max(maxN, ulazi[i]);
    }

    vector<int> prod(maxN + 1);
    prod[0] = 0;

    for (int i = 1; i <= maxN; i++) {
        prod[i] = prod[i / 10] * (i % 10);
        if (i < 10) prod[i] = i;
    }

    for (int n : ulazi) {
        unordered_set<int> razliciti;
        razliciti.reserve(1000); 

        for (int i = 1; i <= n; i++) {
            razliciti.insert(prod[i]);
        }

        cout << razliciti.size() << '\n';
    }

    return 0;
}